<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuotesItemsModel extends Model
{
    use HasFactory;
    protected $table = 'quote_items';
    protected $primaryKey = 'id';
    protected $fillable = [
        'quote_id',
        'product_id',
        'product_name',
        'available_quantity',
        'quantity',
        'price',
        'total',
    ];
    public function quote()
    {
        return $this->belongsTo(QuotesModel::class, 'quote_id');
    }
    public function product()
    {
        return $this->belongsTo(ProductModel::class, 'product_id');
    }
    public function quoteItemTaxes()
    {
        return $this->hasMany(QuotesItemTaxModel::class, 'quotes_item_id', 'id');
    }
}
