@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header d-flex justify-content-between">
                        <div>
                            <h4>Expense Report</h4>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mb-3 px-3">
                            <form method="GET" action="{{ route('expense-report') }}" class="d-flex align-items-center">
                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                                        id="start_date" name="start_date"
                                        value="{{ old('start_date', request()->get('start_date')) }}">

                                    <!-- Display error message for start_date -->
                                    @error('start_date')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                                        id="end_date" name="end_date"
                                        value="{{ old('end_date', request()->get('end_date')) }}">

                                    <!-- Display error message for end_date -->
                                    @error('end_date')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                                <div class="form-group me-2">
                                    <select name="category" id="category" class="form-select">
                                        <option value="">Select Category</option>
                                        @foreach ($category as $id => $category_name)
                                            <option value="{{ $id }}" {{ old('category') == $id ? 'selected' : '' }}>
                                                {{ $category_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary">Filter</button>
                            </form>
                        </div>
                    </div>
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table text-sm" id="myTable2">
                                <thead>
                                    <tr>
                                        <th class="text-center">#</th>
                                        <th class="text-center">Branch Name</th>
                                        <th class="text-center">Expense Category</th>
                                        <th class="text-center">Expense Name</th>
                                        <th class="text-center">Expense Amount</th>
                                        <th class="text-center">Expense Date</th>
                                        <th class="text-center">Created By</th>
                                        <th class="text-center">Updated By</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($expense as $item)
                                        <tr>
                                            <td class="text-center">{{$loop->iteration}}</td>
                                            <td class="text-center">{{ $item->branch->name ?? '' }}</td>
                                            <td class="text-center">{{ $item->category->category_name ?? '' }}</td>
                                            <td class="text-center">{{ $item->expense_name ?? '' }}</td>
                                            <td class="text-center">{{ $item->expense_amount ?? '' }}</td>
                                            <td class="text-center">{{ $item->expense_date ?? '' }}</td>
                                            <td class="text-center">{{ $item->createdBy->name ?? '' }}</td>
                                            <td class="text-center">{{ $item->updatedBy->name ?? '' }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="4" class="text-end">Page Total:</th>
                                        <th id="page-total-selling" class="text-center">₹ 0.00</th>
                                        <th colspan="3"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')

    <script>
        var table = $('#myTable2').DataTable({
            layout: {
                topStart: {
                    buttons: ['excel', 'pdf', 'print', 'colvis', 'pageLength']
                },
            }
        });
        function updatePageTotals() {
            var expenseTotal = 0;

            var rows = table.rows({ page: 'current' }).nodes();

            $(rows).each(function () {
                var expensePrice = parseFloat($(this).find('td:eq(4)').text().replace(/[^\d.-]/g, '')) || 0;

                expenseTotal += expensePrice;
            });

            $('#page-total-selling').html('₹ ' + Math.floor(expenseTotal).toFixed(2));

        }
        table.on('draw', function () {
            updatePageTotals();
        });

        table.on('page', function () {
            updatePageTotals();
        });

        updatePageTotals();
    </script>
@endpush