<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceEmiModel extends Model
{
    protected $table = 'invoice_emi';
    protected $primaryKey = 'id';
    protected $fillable = [
        'invoice_id',
        'actual_amount',
        'intersest_rate',
        'no_of_emi',
        'start_date',
        'penalty_amount',
        'emi_amount',
        'down_payment',
    ];
    public function invoice_emi_dtls()
    {
        return $this->hasMany(InvoiceEmiDtlsModel::class, 'invoice_emi_id', 'id');
    }
    public function invoice()
    {
        return $this->belongsTo(InvoiceModel::class, 'invoice_id', 'invoice_id');
    }
}
