<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>EMO Print  Upload #{{ $upload->id }}</title>
    <style>
        /* ===== Choose your slip height ===== */
        
        /* Option A: 120mm slip */
        /* @page { size: 105mm 120mm portrait; margin: 5mm; }
        .page { height: 120mm; } */

        /* Option B: 127mm slip (standard 5 inch) */
        @page { size: 105mm 127mm portrait; margin: 5mm; }
        .page { height: 127mm; }

        /* Option C: 130mm slip */
        /* @page { size: 105mm 130mm portrait; margin: 5mm; }
        .page { height: 130mm; } */

        body {
            margin: 0;
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 11pt;
            color: #000;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }

        .page {
            width: 105mm;
            margin: auto;
            page-break-after: always;
            text-align: center;
            display: flex;
            align-items: flex-start;
            justify-content: center;
        }

        .content {
            margin-top: 5mm;   /* Move text down slightly */
            line-height: 1.4;
            width: 100%;
        }

        .lbl { font-weight: bold; }
    </style>
</head>
<body onload="window.print()">

@foreach($records as $r)
    <div class="page">
        <div class="content">
            <div>{{ $r->sender_name }},</div>
            <div>
                @if(!empty($r->sender_address1)) {{ $r->sender_address1 }} @endif
                @if(!empty($r->sender_address2)) , {{ $r->sender_address2 }} @endif
                @if(!empty($r->sender_address3)) , {{ $r->sender_address3 }} @endif
                @if(!empty($r->sender_city)) , {{ $r->sender_city }} @endif
                - {{ $r->sender_pincode }}
                @if(!empty($r->sender_mobile)) , {{ $r->sender_mobile }} @endif
            </div>

            <br> <br> <br>



            <div><span class="lbl">EMO No:</span> {{ $r->emo_number }}</div>
            <div><span class="lbl">Received Rs.</span> {{ number_format($r->emo_amount, 2) }} 
                ({{ \App\Helpers\NumberHelper::convertToIndianCurrency($r->emo_amount) }})
            </div>
            <div><span class="lbl">Dated:</span> {{ now()->format('d/m/Y') }}</div>
        </div>
    </div>
@endforeach

</body>
</html>
